<?php
/* --------------------------------------------------------------
   MiddlewareRegistration.php 2020-05-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Application\Kernel\Bootstrapper;

use Gambio\Admin\Application\Middleware\AuthMiddleware;
use Gambio\Admin\Application\Middleware\MiddlewareServiceProvider;
use Gambio\Admin\Application\Middleware\SecurityHeadersMiddleware;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Slim\App as SlimApp;

/**
 * Class MiddlewareRegistration
 * @package Gambio\Admin\Application\Kernel\Bootstrapper
 */
class MiddlewareRegistration extends AbstractBootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        $this->addMiddleware($application);
        
        /** @var SlimApp $slim */
        $slim = $application->get(SlimApp::class);
        $slim->add(AuthMiddleware::class);
        $slim->add(SecurityHeadersMiddleware::class);
    }
    
    
    /**
     * Adds middleware service provider to application container.
     *
     * @param Application $application
     */
    private function addMiddleware(Application $application): void
    {
        $middlewareServiceProvider = new MiddlewareServiceProvider($application);
        $application->addServiceProvider($middlewareServiceProvider->toLeagueInterface());
    }
}